<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\Http;

use App\Models\KanbanAccounts;
use App\Models\Boards;
use App\Models\BoardStages;
use App\Models\BoardCollaborators;
use App\Models\BoardSwimlanes;
use App\Models\BoardTasks;
use App\Models\TaskTimers;
use App\Models\LastImportedTiming;
use App\Models\CronLogs;

class ImportKanban extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:kanban';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'import data from kanban api twice a day.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $last_imported_time = LastImportedTiming::first();

        $cron_start_time = date('Y-m-d H:i:s',time());

        $insert_log['type'] = "cron-start";
        $insert_log['description'] = $cron_start_time;
        CronLogs::create($insert_log);


        $KanbanAccounts = KanbanAccounts::where('account_name', '!=', "test-teqpier")->get();
        
        //$KanbanAccounts = [];

        foreach($KanbanAccounts as $ka)
        {
            $insert_log['type'] = "account";
            $insert_log['description'] = $ka->id." - ". date('Y-m-d H:i:s',time());
            CronLogs::create($insert_log);

            $response = Http::withHeaders([
                        'Authorization' => 'Bearer '.$ka->token
                    ])->get('https://'.$ka->url.'/api/v3/users/current.json');

            $result = $response->getBody()->getContents();

            $details = json_decode($result);

            $insert_log['type'] = "account-result";
            $insert_log['description'] = $result."-".$ka->id." - ". date('Y-m-d H:i:s',time());
            CronLogs::create($insert_log);

            $new_boards = [];

            foreach($details->boards as $board)
            {
                $insert_log['type'] = "board";
                $insert_log['description'] = $board->id." - ". date('Y-m-d H:i:s',time());
                CronLogs::create($insert_log);

                $new_boards[] = $board->id;

                $b_inserted = Boards::updateOrCreate([
                            'kanban_account_id' => $ka->id,
                            'board_id'   => $board->id,
                        ],[
                            'kanban_account_id' => $ka->id,
                            'board_id' => $board->id,
                            'name' => $board->name,
                            'position' => $board->position,
                            'last_activity_on' => $board->last_activity_on,
                            'permissions' => json_encode($board->permissions),
                        ]);

                $response_board_details = Http::timeout(300)->withHeaders([
                        'Authorization' => 'Bearer '.$ka->token
                    ])->get('https://'.$ka->url.'/api/v3/boards/'.$board->id.'.json');
        
                $result_board = $response_board_details->getBody()->getContents();

                $board_detail = json_decode($result_board);

                $insert_log['type'] = "board-result";
                $insert_log['description'] = $board->id." - ". date('Y-m-d H:i:s',time());
                CronLogs::create($insert_log);

                $settings = $board_detail->settings->card_template;
                $settings = json_decode(json_encode($settings) , true);
                $invoice_field = "";

                foreach($settings as $ks => $bs)
                {
                    if (array_key_exists("label",$bs))
                    {
                        if($bs['label'] == "Invoice value") 
                        {
                            $invoice_field = $ks;
                        }
                    }
                }

                // swimlanes
                $swimlanes = [];

                foreach($board_detail->swimlanes as $swimlane)
                {
                   $single_swimlane = [];
                   $single_swimlane['board_id'] = $b_inserted->id;
                   $single_swimlane['swimlane_id'] = $swimlane->id;
                   $single_swimlane['name'] = $swimlane->name;
                   $single_swimlane['limit'] = $swimlane->limit;
                   $single_swimlane['position'] = $swimlane->position;
                   $single_swimlane['description'] = $swimlane->description;

                   array_push($swimlanes, $single_swimlane);
                }

                if(count($swimlanes) > 0)
                {
                    $insert_log['type'] = "swimlanes-insert";
                    $insert_log['description'] = json_encode($swimlanes)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    BoardSwimlanes::upsert($swimlanes,["board_id", "swimlane_id"]);
                }

                // collaborators
                $collaborators = [];
                $collaborator_ids = [];
                foreach($board_detail->collaborators as $collaborator)
                {
                    array_push($collaborator_ids, $collaborator->id);

                   $single_collaborator = [];
                   $single_collaborator['board_id'] = $b_inserted->id;
                   $single_collaborator['collaborator_id'] = $collaborator->id;
                   $single_collaborator['name'] = $collaborator->name;
                   $single_collaborator['initials'] = $collaborator->initials;
                   $single_collaborator['active'] = $collaborator->active;

                   array_push($collaborators, $single_collaborator);
                }

                if(count($collaborators) > 0)
                {
                    $insert_log['type'] = "collaborators-insert";
                    $insert_log['description'] = json_encode($collaborators)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    BoardCollaborators::upsert($collaborators,["board_id", "collaborator_id"]);
                }

                if(count($collaborator_ids) > 0)
                {
                    $insert_log['type'] = "collaborator-delete";
                    $insert_log['description'] = json_encode($collaborator_ids)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    $delete_c = BoardCollaborators::where('board_id',$b_inserted->id)->whereNotIn('collaborator_id', $collaborator_ids)->delete();
                }

                //workflow stages
                $stages = [];
                $stage_ids = [];
                foreach($board_detail->workflow_stages as $stage)
                {
                    array_push($stage_ids, $stage->id);

                    $single_stage = [];
                    $single_stage['board_id'] = $b_inserted->id;
                    $single_stage['stage_id'] = $stage->id;
                    $single_stage['kb_board_id'] = $stage->board_id;
                    $single_stage['name'] = $stage->name;
                    $single_stage['full_name'] = $stage->full_name;
                    $single_stage['wip_limit'] = $stage->wip_limit;
                    $single_stage['wip_limit_type'] = $stage->wip_limit_type;
                    $single_stage['position'] = $stage->position;
                    $single_stage['lane_width'] = $stage->lane_width;
                    $single_stage['parent_id'] = $stage->parent_id;
                    $single_stage['lft'] = $stage->lft;
                    $single_stage['rgt'] = $stage->rgt;
                    $single_stage['board_version'] = $stage->board_version;
                    $single_stage['description'] = $stage->description;
                    $single_stage['lane_type_id'] = $stage->lane_type_id;
                    $single_stage['archive_enabled'] = $stage->archive_enabled;
                    $single_stage['lane_type'] = $stage->lane_type;

                    array_push($stages, $single_stage);
                }

                if(count($stages) > 0)
                {
                    $insert_log['type'] = "stages-insert";
                    $insert_log['description'] = json_encode($stages)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    BoardStages::upsert($stages,["board_id", "stage_id"]);
                }

                if(count($stage_ids) > 0)
                {
                    $insert_log['type'] = "stage-delete";
                    $insert_log['description'] = json_encode($stage_ids)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    $delete_s = BoardStages::where('kb_board_id',$board->id)->whereNotIn('stage_id', $stage_ids)->delete();
                }

                // Tasks
                $tasks = [];
                $task_ids = [];

                foreach($board_detail->tasks as $task)
                {
                    array_push($task_ids, $task->id);

                    if(empty($last_imported_time) || (strtotime($task->updated_at) > strtotime($last_imported_time->time)))
                    {
                        $task_timers = [];

                        $single_task = [];
                        $single_task['board_id'] = $b_inserted->id;
                        $single_task['task_id'] = $task->id;
                        $single_task['kb_board_id'] = $task->board_id;
                        $single_task['kb_workflow_stage_id'] = $task->workflow_stage_id;
                        $single_task['name'] = $task->name;
                        $single_task['description'] = $task->description;
                        $single_task['kb_swimlane_id'] = $task->swimlane_id;
                        $single_task['kb_created_at'] = date("Y-m-d H:i:s", strtotime($task->created_at));
                        $single_task['kb_updated_at'] = date("Y-m-d H:i:s", strtotime($task->updated_at));
                        $single_task['kb_created_by_id'] = $task->created_by_id;
                        $single_task['time_estimate'] = $task->time_estimate;
                        $single_task['timers_total'] = ($task->timers_total != "" && $task->timers_total > 0) ? $task->timers_total : 0;
                        $single_task['assigned_user_id'] = $task->assigned_user_id;
                        if($invoice_field != "")
                        {
                            $single_task['invoice'] = ($task->$invoice_field != "" && is_numeric($task->$invoice_field)) ? $task->$invoice_field : 0;
                        }

                        array_push($tasks, $single_task);

                        // if($task->timers_listed_count > 0)
                        // {
                        //    $response_task_details = Http::timeout(300)->withHeaders([
                        //     'Authorization' => 'Bearer '.$ka->token
                        //     ])->get('https://'.$ka->url.'/api/v3/tasks/'.$task->id.'.json');
                
                        //     $result_task = $response_task_details->getBody()->getContents();

                        //     $task_detail = json_decode($result_task);

                        //     foreach($task_detail->time_trackers as $tt)
                        //     {
                        //         $single_time = [];
                        //         $single_time['user_id']=$tt->user_id;
                        //         $single_time['board_id']=$tt->board_id;
                        //         $single_time['task_id']=$tt->task_id;
                        //         $single_time['listed']=$tt->listed;
                        //         $single_time['started_at']= ($tt->started_at != "") ? date('Y-m-d H:i:s', strtotime($tt->started_at)) : NULL;
                        //         $single_time['ended_at']= ($tt->ended_at != "") ? date('Y-m-d H:i:s', strtotime($tt->ended_at)) : NULL;

                        //         array_push($task_timers, $single_time);
                        //     }
                        // }

                        // if(count($task_timers)>0)
                        // {
                        //     TaskTimers::where('task_id',$task->id)->delete();

                        //     $chunked_tt = array_chunk($task_timers, 100);
                        //     foreach($chunked_tt as $tt_insert)
                        //     {
                        //         TaskTimers::insert($tt_insert);
                        //     }
                        // }
                    }
                }

                if(count($tasks) > 0)
                {
                    $insert_log['type'] = "tasks-insert";
                    $insert_log['description'] = json_encode($tasks)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    BoardTasks::upsert($tasks,["board_id", "task_id"]);
                }

                if(count($task_ids) > 0)
                {
                    $insert_log['type'] = "tasks-delete";
                    $insert_log['description'] = json_encode($task_ids)." - ". date('Y-m-d H:i:s',time()). "- ". $board->id;
                    CronLogs::create($insert_log);

                    $delete_t = BoardTasks::where('kb_board_id',$board->id)->whereNotIn('task_id', $task_ids)->delete();

                    $delete_tt = TaskTimers::where('board_id',$board->id)->whereNotIn('task_id', $task_ids)->delete();
                }
                
            }

            //Boards::whereNotIn("board_id", $new_boards)->where("kanban_account_id", $ka->id)->delete();
        }

        if(empty($last_imported_time))
        {
            $insert['time'] = $cron_start_time;
            LastImportedTiming::create($insert);
        }
        else
        {
            $last_imported_time->time = $cron_start_time;
            $last_imported_time->save();
        }

        $insert_log['type'] = "cron-end";
        $insert_log['description'] = date('Y-m-d H:i:s',time());
        CronLogs::create($insert_log);
    }
}
