<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Boards;
use App\Models\ExceptionMappings;
use App\Models\DailyExceptionSnapshot;
use App\Models\ExceptionMappingLevels;

use App\Http\Controllers\ExceptionController;

use Carbon\Carbon;

class SnapshotException extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'snapshot:exception';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Exception Snapshot daily backup.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $data = [];

        $boards = Boards::get();

        $levels = ExceptionMappingLevels::get();

        foreach($boards as $board)
        {
            $mappings = ExceptionMappings::with(['exception_relations' => function($q) use($board) {
                $q->where("board_id", $board->id);
            }])->whereNull("level_id")->get();

            if(count($mappings) > 0)
            {
                $controller = new ExceptionController();

                $records = $controller->process_data($board, $mappings, $data);

                $data_insert = [];
            
                $date = Carbon::now();
                $today = $date->format('Y-m-d');

                $data_single = [];
                $data_single['date'] = $today;
                $data_single['board_id'] = $board->id;
                $data_single['board_name'] = $board->name;
                $data_single['type'] = 'head';

                $head_arr = [];
                $head_arr[] = "Job No.";
                $head_arr[] = "Estimated Time";
                $head_arr[] = "Logged Time";
                $head_arr[] = "Exceed Estimate 10%";
                $head_arr[] = "Exceed Estimate 10%";
                $head_arr[] = "Assigned User";
                
                $data_single['data'] = json_encode($head_arr);

                array_push($data_insert,$data_single);

                foreach($records as $record)
                {
                    $data_single = [];
                    $data_single['date'] = $today;
                    $data_single['board_id'] = $board->id;
                    $data_single['board_name'] = $board->name;
                    $data_single['type'] = 'body';

                    $data_single['data'] = json_encode($record);

                    array_push($data_insert,$data_single);
                }

                DailyExceptionSnapshot::upsert($data_insert, 'id');
            }
            

            foreach($levels as $l)
            {
                $mappings = ExceptionMappings::with(['exception_relations' => function($q) use($board) {
                    $q->where("board_id", $board->id);
                }])->where("level_id", $l->id)->get();

                if(count($mappings) > 0)
                {
                    $controller = new ExceptionController();
                    
                    $request = new \stdClass();
                    $request->level_select = $l->id;

                    $records = $controller->process_data($board, $mappings, $data, $request);

                    $data_insert = [];
                
                    $date = Carbon::now();
                    $today = $date->format('Y-m-d');

                    $data_single = [];
                    $data_single['level_id'] = $l->id;
                    $data_single['level_label'] = $l->label;
                    $data_single['date'] = $today;
                    $data_single['board_id'] = $board->id;
                    $data_single['board_name'] = $board->name;
                    $data_single['type'] = 'head';

                    $head_arr = [];
                    $head_arr[] = "Job No.";
                    $head_arr[] = "Estimated Time";
                    $head_arr[] = "Logged Time";
                    $head_arr[] = "Exceed Estimate 10%";
                    $head_arr[] = "Assigned User";
                    
                    $data_single['data'] = json_encode($head_arr);

                    array_push($data_insert,$data_single);

                    foreach($records as $record)
                    {
                        $data_single = [];
                        $data_single['level_id'] = $l->id;
                        $data_single['level_label'] = $l->label;
                        $data_single['date'] = $today;
                        $data_single['board_id'] = $board->id;
                        $data_single['board_name'] = $board->name;
                        $data_single['type'] = 'body';

                        $data_single['data'] = json_encode($record);

                        array_push($data_insert,$data_single);


                    }

                    DailyExceptionSnapshot::upsert($data_insert, 'id');
                }
            }
        }

    }
}
