<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Boards;
use App\Models\GlobalSSMappings;
use App\Models\DailyGlobalSnapshot;
use App\Models\GlobalSSMappingLevels;

use App\Http\Controllers\GlobalSnapshotController;

use Carbon\Carbon;

class SnapshotGlobal extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'snapshot:global';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Global Snapshot daily backup.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $data = [];
        $data['mapped']=[];
        $data['notmapped']=[];

        $boards = Boards::orderBy('order')->get();
        $levels = GlobalSSMappingLevels::get();
        

        $mappings = GlobalSSMappings::whereNull("level_id")->orderBy('label')->get();

        if(count($mappings) > 0)
        {
            $controller = new GlobalSnapshotController();

            $records = $controller->process_data($boards, $mappings, $data);

            $data_insert = [];
            
            $date = Carbon::now();
            $today = $date->format('Y-m-d');

            $data_single = [];
            $data_single['date'] = $today;
            $data_single['type'] = 'head';

            $head_arr = [];
            $head_arr[] = "";
            foreach($boards as $b)
            {
                $head_arr[] = $b->name;
            }
            $head_arr[] = "TOTAL";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            foreach($records['mapped'] as $data_mapped)
            {
                $data_single = [];
                $data_single['date'] = $today;
                $data_single['type'] = 'body';

                $data_single['data'] = json_encode($data_mapped);

                array_push($data_insert,$data_single);
            }

            $data_single = [];
            $data_single['date'] = $today;
            $data_single['type'] = 'body';

            $head_arr = [];
            $head_arr[] = "<b>TOTAL</b>";
            foreach($records['vertical_total'] as $vt)
            {
                $head_arr[] = "<b>".$vt."</b>";
            }
            $head_arr[] = "<b>".array_sum($records['vertical_total'])."</b>";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            DailyGlobalSnapshot::upsert($data_insert, 'id');

        }


        foreach($levels as $l)
        {
            $mappings = GlobalSSMappings::where("level_id", $l->id)->orderBy('label')->get();

            $controller = new GlobalSnapshotController();

            $records = $controller->process_data($boards, $mappings, $data);

            $data_insert = [];
            
            $date = Carbon::now();
            $today = $date->format('Y-m-d');

            $data_single = [];
            $data_single['level_id'] = $l->id;
            $data_single['level_label'] = $l->label;
            $data_single['date'] = $today;
            $data_single['type'] = 'head';

            $head_arr = [];
            $head_arr[] = "";
            foreach($boards as $b)
            {
                $head_arr[] = $b->name;
            }
            $head_arr[] = "TOTAL";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            foreach($records['mapped'] as $data_mapped)
            {
                $data_single = [];
                $data_single['level_id'] = $l->id;
                $data_single['level_label'] = $l->label;
                $data_single['date'] = $today;
                $data_single['type'] = 'body';

                $data_single['data'] = json_encode($data_mapped);

                array_push($data_insert,$data_single);
            }

            $data_single = [];
            $data_single['level_id'] = $l->id;
            $data_single['level_label'] = $l->label;
            $data_single['date'] = $today;
            $data_single['type'] = 'body';

            $head_arr = [];
            $head_arr[] = "<b>TOTAL</b>";
            foreach($records['vertical_total'] as $vt)
            {
                $head_arr[] = "<b>".$vt."</b>";
            }
            $head_arr[] = "<b>".array_sum($records['vertical_total'])."</b>";
            $data_single['data'] = json_encode($head_arr);

            array_push($data_insert,$data_single);


            DailyGlobalSnapshot::upsert($data_insert, 'id');
        }

    }
}
