<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use App\Models\Boards;
use App\Models\InvoiceMappings;
use App\Models\DailyInvoiceSnapshot;
use App\Models\InvoiceMappingLevels;

use App\Http\Controllers\InvoiceController;

use Carbon\Carbon;

class SnapshotInvoice extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'snapshot:invoice';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Invoice Snapshot daily backup.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $data = [];

        $boards = Boards::get();
        $levels = InvoiceMappingLevels::get();

        foreach($boards as $board)
        {
            $mappings = InvoiceMappings::with(['invoice_relations' => function($q) use($board) {
                    $q->where("board_id", $board->id);
                }])->whereNull("level_id")->get();

            if(count($mappings) > 0)
            {
                $controller = new InvoiceController();

                $records = $controller->process_data($board, $mappings, $data);

                $data_insert = [];
            
                $date = Carbon::now();
                $today = $date->format('Y-m-d');

                $data_single = [];
                $data_single['date'] = $today;
                $data_single['board_id'] = $board->id;
                $data_single['board_name'] = $board->name;
                $data_single['type'] = 'head';

                $head_arr = [];
                $head_arr[] = "Job No.";
                $head_arr[] = "Estimated Time";
                $head_arr[] = "Actual Time";
                $head_arr[] = "Invoice";
                $head_arr[] = "Time %";
                $head_arr[] = "Fee p.h.";
                
                $data_single['data'] = json_encode($head_arr);

                array_push($data_insert,$data_single);


                foreach($records as $record)
                {
                    $data_single = [];
                    $data_single['date'] = $today;
                    $data_single['board_id'] = $board->id;
                    $data_single['board_name'] = $board->name;
                    $data_single['type'] = 'body';

                    $data_single['data'] = json_encode($record);

                    array_push($data_insert,$data_single);
                }

                DailyInvoiceSnapshot::upsert($data_insert, 'id');
            }


            foreach($levels as $l)
            {
                $mappings = InvoiceMappings::with(['invoice_relations' => function($q) use($board) {
                    $q->where("board_id", $board->id);
                }])->where("level_id", $l->id)->get();

                if(count($mappings) > 0)
                {
                    $controller = new InvoiceController();

                    $records = $controller->process_data($board, $mappings, $data);

                    $data_insert = [];
                
                    $date = Carbon::now();
                    $today = $date->format('Y-m-d');

                    $data_single = [];
                    $data_single['level_id'] = $l->id;
                    $data_single['level_label'] = $l->label;
                    $data_single['date'] = $today;
                    $data_single['board_id'] = $board->id;
                    $data_single['board_name'] = $board->name;
                    $data_single['type'] = 'head';

                    $head_arr = [];
                    $head_arr[] = "Job No.";
                    $head_arr[] = "Estimated Time";
                    $head_arr[] = "Actual Time";
                    $head_arr[] = "Invoice";
                    $head_arr[] = "Time %";
                    $head_arr[] = "Fee p.h.";
                    
                    $data_single['data'] = json_encode($head_arr);

                    array_push($data_insert,$data_single);


                    foreach($records as $record)
                    {
                        $data_single = [];
                        $data_single['level_id'] = $l->id;
                        $data_single['level_label'] = $l->label;
                        $data_single['date'] = $today;
                        $data_single['board_id'] = $board->id;
                        $data_single['board_name'] = $board->name;
                        $data_single['type'] = 'body';

                        $data_single['data'] = json_encode($record);

                        array_push($data_insert,$data_single);
                    }

                    DailyInvoiceSnapshot::upsert($data_insert, 'id');
                }
            }
        }

    }
}
