<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('import:kanban')->twiceDaily(8, 12);

        $schedule->command('snapshot:global')->dailyAt('23:00');

        $schedule->command('snapshot:workload')->dailyAt('23:00');

        $schedule->command('snapshot:invoice')->dailyAt('23:00');

        $schedule->command('snapshot:exception')->dailyAt('23:00');

        $schedule->command('queue:work --tries=3 --stop-when-empty')->everyFifteenMinutes();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }


    protected function scheduleTimezone()
    {
        return 'Australia/Brisbane';
    }
}
