<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;

use App\Models\Boards;

use Illuminate\Http\Request;
use Flash;
use Response;

class BoardOrderController extends AppBaseController
{
	public function index(Request $request)
    {
    	$boards = Boards::orderBy('order')->get();

    	// echo "<pre>";
    	// print_r($boards);
    	// exit;

    	return view('board_order.index')
            ->with('boards', $boards);
    }

    public function update_order(Request $request)
    {
        $data = $request->all();
        
        if(isset($data['boards']))
        {
            for($i=0; $i < count($data['boards']); $i++)
            {
                $board = Boards::find($data['boards'][$i]);
                $board->order = $i;
                $board->save();
            }
        }

        return Response::json('Order updated successfully');
    }
}