<?php

namespace App\Http\Controllers;

use App\Http\Controllers\AppBaseController;

use App\Models\KanbanAccounts;
use App\Models\BoardSwimlanes;
use App\Models\Boards;
use App\Models\BoardTasks;
use App\Models\GlobalSSMappings;
use App\Models\GlobalSSRelations;
use App\Models\DailyGlobalSnapshot;
use App\Models\GlobalSSMappingLevels;
use App\Models\RoleLevels;

use Illuminate\Http\Request;
use Flash;
use Response;
use Carbon\Carbon;

class GlobalSnapshotController extends AppBaseController
{
    /**
     * Display a listing of the Swimline Report.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function index(Request $request)
    {
        $boards = Boards::orderBy('order')->get();

        if(isset($request->date) && $request->date!="")
        {
            $role_id = \Auth::user()->role->id;
            
            if($role_id == 1)
            {
                $levels = GlobalSSMappingLevels::get();
            }
            else
            {
                $level_ids = RoleLevels::where('role_id', $role_id)->where('type', 'global')->pluck('level_id');

                $levels = GlobalSSMappingLevels::whereIn("id", $level_ids)->get();
            }

            

            $newDate = Carbon::createFromFormat('d-m-Y', $request->date)
                                    ->format('Y-m-d');

            $data['head'] = DailyGlobalSnapshot::where('type', 'head')->where("level_id", $request->level_select)->where('date', $newDate)->first();
            $data['body'] = DailyGlobalSnapshot::where('type', 'body')->where("level_id", $request->level_select)->where('date', $newDate)->get();

            return view('global_snapshot.snapshot')
                ->with('boards', $boards)->with('data', $data)->with('request',$request)->with('levels', $levels);
        }
        else
        {
            $role_id = \Auth::user()->role->id;
            
            if($role_id == 1)
            {
                $levels = GlobalSSMappingLevels::whereIn("id", GlobalSSMappings::pluck("level_id"))->get();
            }
            else
            {
                $level_ids = RoleLevels::where('role_id', $role_id)->where('type', 'global')->pluck('level_id');
                $levels = GlobalSSMappingLevels::whereIn("id", GlobalSSMappings::pluck("level_id"))->whereIn("id", $level_ids)->get();
            }

            $data = [];
            $data['mapped']=[];
            $data['notmapped']=[];

            $mappings = GlobalSSMappings::where("level_id", $request->level_select)->orderBy('label')->get();

            $data = $this->process_data($boards, $mappings, $data, $request);

            return view('global_snapshot.index')
                ->with('boards', $boards)->with('data', $data)->with('request',$request)->with('levels', $levels);
        }
        

    }

    public function process_data($boards, $mappings, $data, $request = null)
    {

        $vertical_total = [];
        
        foreach($mappings as $key_map => $mapping)
        {
            $mapped_swimlanes_inner = [];
            $mapped_stages_inner = [];

            $horizontal_total = 0;
            foreach($mapping->global_ss_relations as $sr)
            {
                $mapped_swimlanes_inner = array_merge($mapped_swimlanes_inner,explode(',', $sr->swimlane_ids));

                $mapped_stages_inner = array_merge($mapped_stages_inner,explode(',', $sr->stage_ids));
                
            }
            foreach($boards as $kb => $b)
            {
                $data['mapped'][$key_map][0]=$mapping->label;
                $qry = BoardTasks::where('board_id',$b->id)->whereIn('kb_swimlane_id', $mapped_swimlanes_inner)->whereIn('kb_workflow_stage_id', $mapped_stages_inner);

                $task_count = $qry->count();
                $vertical_total[$kb] = ((isset($vertical_total[$kb])) ? $vertical_total[$kb] : 0) + $task_count;
                $data['mapped'][$key_map][$b->id] = $task_count;
                $horizontal_total = $horizontal_total+$task_count;
            }
            $data['mapped'][$key_map][]= "<b>".$horizontal_total."</b>";
        }

        $data['vertical_total'] = $vertical_total;


        return $data;
    }

    public function process_data_dashboard($boards, $mappings, $data, $request = null)
    {
        
        foreach($mappings as $key_map => $mapping)
        {
            $mapped_swimlanes_inner = [];
            $mapped_stages_inner = [];

            $horizontal_total = 0;
            foreach($mapping->global_ss_relations as $sr)
            {
                $mapped_swimlanes_inner = array_merge($mapped_swimlanes_inner,explode(',', $sr->swimlane_ids));

                $mapped_stages_inner = array_merge($mapped_stages_inner,explode(',', $sr->stage_ids));
                
            }
            $data[$key_map]['name']=$mapping->label;
            foreach($boards as $kb => $b)
            {
                
                $qry = BoardTasks::where('board_id',$b->id)->whereIn('kb_swimlane_id', $mapped_swimlanes_inner)->whereIn('kb_workflow_stage_id', $mapped_stages_inner);

                $task_count = $qry->count();
                
                $horizontal_total = $horizontal_total+$task_count;
            }
            $data[$key_map]['total']= $horizontal_total;
        }

        return $data;
    }
}