<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class InvoiceMappings
 * @package App\Models
 * @version July 21, 2022, 12:15 pm UTC
 *
 */
class InvoiceMappings extends Model
{

    public $table = 'invoice_mappings';

    public $fillable = ["label", "level_id"];

    public function invoice_relations()
    {
        return $this->hasMany(InvoiceRelations::class, 'invoice_mapping_id', 'id');
    }

    public function level()
    {
        return $this->hasOne(InvoiceMappingLevels::class, 'id', 'level_id');
    }

}