<?php

namespace App\Models;

use Eloquent as Model;

/**
 * Class Roles
 * @package App\Models
 * @version October 11, 2022, 8:47 am UTC
 *
 * @property string $name
 * @property string $description
 */
class Roles extends Model
{

    public $table = 'roles';
    



    public $fillable = [
        'name',
        'description'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'description' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rulescreate = [
        'name' => 'required|unique:roles,name',
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static function rulesupdate($id)
    {

       return [
        'name' => 'required|unique:roles,name,'.$id,
        ]; 
    } 

    
}
