<?php
use Carbon\Carbon;
use Carbon\CarbonInterval;

use App\Models\LastImportedTiming;
use App\Models\Jobs;

function get_time_text($timer)
{
    if($timer > 0)
    {
        $dt = Carbon::now();
        $days = $dt->diffInDays($dt->copy()->addSeconds($timer));
        $hours = $dt->diffInHours($dt->copy()->addSeconds($timer)->subDays($days));
        $minutes = $dt->diffInMinutes($dt->copy()->addSeconds($timer)->subDays($days)->subHours($hours));
        return  CarbonInterval::days($days)->hours($hours)->minutes($minutes)->forHumans();
    }
    else
    {
        return 0;
    }
	
}

function get_last_data_import_time()
{
    $last_time = LastImportedTiming::first();

    if(!empty($last_time))
    {
        $datetime = Carbon::createFromFormat('Y-m-d H:i:s', $last_time->time);
        $datetime->setTimezone('Australia/Brisbane');
        return $datetime;     
    }
    return ''; 
}

function is_running_job()
{
    $job = Jobs::first();

    if(!empty($job))
    {
        return true;
    }

    return false;
}

?>