<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('boards', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('kanban_account_id');
            $table->unsignedInteger('board_id');
            $table->string('name')->nullable();
            $table->unsignedInteger('position')->nullable();
            $table->date('last_activity_on')->nullable();
            $table->text('permissions')->nullable();
            $table->timestamps();

            $table->foreign('kanban_account_id')->references('id')->on('kanban_accounts')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('boards');
    }
};
