<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('board_tasks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('board_id');
            $table->unsignedInteger('task_id');
            $table->unsignedInteger('kb_board_id');
            $table->unsignedInteger('kb_workflow_stage_id');
            $table->text('name')->nullable();
            $table->text('description')->nullable();
            $table->unsignedInteger('kb_swimlane_id')->nullable();

            $table->timestamps();

            $table->unique(['board_id', 'task_id']);

            $table->foreign('board_id')->references('id')->on('boards')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('board_tasks');
    }
};
