<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swimlane_mapping_relations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swimlane_mapping_id');
            $table->unsignedBigInteger('board_id');
            $table->unsignedInteger('swimlane_id');

            $table->foreign('swimlane_mapping_id')->references('id')->on('swimlane_mappings')->onUpdate('cascade')->onDelete('cascade');

            $table->foreign('board_id')->references('id')->on('boards')->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swimlane_mapping_relations');
    }
};
