<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('board_tasks', function (Blueprint $table) {
            $table->timestampTz('kb_created_at')->after('kb_swimlane_id')->nullable();
            $table->timestampTz('kb_updated_at')->after('kb_created_at')->nullable();
            $table->unsignedInteger('kb_created_by_id')->after('kb_updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('board_tasks', function (Blueprint $table) {
            $table->dropColumn('kb_created_at');
            $table->dropColumn('kb_updated_at');
            $table->dropColumn('kb_created_by_id');
        });
    }
};
