@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
Exception Mapping @parent
@stop

@section('header_styles')
    <!--Plugin styles-->
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/inputlimiter/css/jquery.inputlimiter.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/chosen/css/chosen.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/jquery-tagsinput/css/jquery.tagsinput.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/daterangepicker/css/daterangepicker.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/datepicker/css/bootstrap-datepicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/bootstrap-switch/css/bootstrap-switch.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/jasny-bootstrap/css/jasny-bootstrap.min.css')}}"/>
    <link type="text/css" rel="stylesheet" href="{{asset('vendors/multiselect/css/multi-select.css')}}"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
    <link type="text/css" rel="stylesheet" href="{{asset('css/pages/form_elements.css')}}"/>
    <!-- end of page level styles -->
@stop

@section('content')
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Exception Mapping
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="{{ route('home') }}">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('exception_mapping.index') }}">Exception Mappings</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Update') }} Exception Mapping</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        @include('flash::message')

        <div class="clearfix"></div>
        <div class="card m-t-10">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Exception Mapping</h5>
            </div>
            <div class="card-body p-b-200">
                {!! Form::model($ExceptionMappings, ['route' =>
                ['exception_mapping.update',
                $ExceptionMappings->id], 'method' => 'patch','class' => 'form-horizontal']) !!}
                    <div class="row">
                        <div class="col-md-12 input_field_sections">
                            <h5>Level</h5>
                            <div class="row">
                                <div class="col-lg-3 m-t-10">
                                    <select class="form-control chzn-select" name="level_select" id="level_select">
                                        <option value="">Select</option>
                                        @foreach($levels as $l)
                                        <option @if($ExceptionMappings->level_id == $l->id) selected @endif value="{{$l->id}}">{{$l->label}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-lg-3 m-t-10">
                                    <button type="button" class="btn btn-primary" onclick="display_new()">Add New</button>
                                </div>
                            </div>
                            <div class="row display_new" style="display:none">
                                <div class="col-lg-3">
                                    <input type="text" class="form-control" name="level_new" id="level_new" placeholder="New Level" 
                                       value=""/>
                                </div>
                            </div>
                            @error('level_new')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-3 input_field_sections">
                            <h5>Label</h5>
                            <input type="text" required class="form-control" name="label"
                                       value="{{$ExceptionMappings->label}}"/>
                        </div>
                    </div>
                    <div class="row m-t-10">
                        @foreach($boards as $board)
                        <input type="hidden" name="boards[]" value="{{$board->id}}">
                        <div class="card col-lg-6 m-t-10">
                            <div class="card-header bg-white">
                                <h5 class="card-title d-inline">{{$board->name}}</h5>
                            </div>
                            <div class="card-body">
                                <div class="col-lg-12 m-t-10">
                                    <div class="col-lg ">
                                        <h5>Swimlane</h5>
                                        <select multiple class="form-control chzn-select" name="swimlanes[{{$board->id}}][]" tabindex="2">
                                            <option value="">Select</option>
                                            @foreach($board->swimlanes as $sl)
                                            <option @if(in_array($sl->swimlane_id, $board->selected_swimlanes)) selected @endif value="{{$sl->swimlane_id}}">{{$sl->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-12 m-t-10">
                                    <div class="col-lg ">
                                        <h5>Stages</h5>
                                        <select multiple class="form-control chzn-select" name="stages[{{$board->id}}][]" tabindex="2">
                                            @foreach($board->tree_stages as $s)
                                            @if(isset($s['children']))
                                            <optgroup label="{{$s['name']}}">
                                                @foreach($s['children'] as $fc)
                                                    @if(isset($fc['children']))
                                                    <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;{{$fc['name']}}">
                                                        @foreach($fc['children'] as $sc)
                                                            @if(isset($sc['children']))
                                                            <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$sc['name']}}">
                                                                @foreach($sc['children'] as $tc)
                                                                @if(isset($tc['children']))
                                                                <optgroup label="&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$tc['name']}}">
                                                                </optgroup>
                                                                @else
                                                                <option @if(in_array($tc['stage_id'], $board->selected_stages)) selected @endif value="{{$tc['stage_id']}}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$tc['name']}}</option>
                                                                @endif
                                                            @endforeach
                                                            </optgroup>
                                                            @else
                                                            <option @if(in_array($sc['stage_id'], $board->selected_stages)) selected @endif value="{{$sc['stage_id']}}">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{{$sc['name']}}</option>
                                                            @endif
                                                        @endforeach
                                                    </optgroup>
                                                    @else
                                                    <option @if(in_array($fc['stage_id'], $board->selected_stages)) selected @endif value="{{$fc['stage_id']}}">&nbsp;&nbsp;&nbsp;&nbsp;{{$fc['name']}}</option>
                                                    @endif
                                                @endforeach
                                            </optgroup>
                                            @else
                                            <option value="{{$s['stage_id']}}">{{$s['name']}}</option>
                                            @endif
                                            
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    <div class="row m-t-20">
                        <div class="col-lg-3">
                            <input type="submit" class="btn btn-primary" value="save" />
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_scripts')
<!-- plugin level scripts -->
    <script type="text/javascript" src="{{asset('vendors/jquery.uniform/js/jquery.uniform.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputlimiter/js/jquery.inputlimiter.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/chosen/js/chosen.jquery.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pluginjs/jquery.validVal.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/moment/js/moment.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/daterangepicker/js/daterangepicker.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/datepicker/js/bootstrap-datepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/autosize/js/jquery.autosize.min.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/jquery.inputmask.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.date.extensions.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/inputmask/js/inputmask.extensions.js')}}"></script>
    <script type="text/javascript" src="{{asset('vendors/multiselect/js/jquery.multi-select.js')}}"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jquery.quicksearch/2.3.1/jquery.quicksearch.min.js"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="{{asset('js/form.js')}}"></script>
    <script type="text/javascript" src="{{asset('js/pages/form_elements.js')}}"></script>

    <script type="text/javascript">
        function display_new()
        {
            $("#level_select").val("").trigger("chosen:updated");
            $(".display_new").show();
        }

        $(document).ready(function() {
            $("#level_select").on("change", function(){
                $("#level_new").val("");
                $(".display_new").hide();
            })
        })
    </script>
@stop