@extends('layouts.compact_menu')

{{-- Page title --}}
@section('title')
Global Snapshot Mapping @parent
@stop

@section('content')
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Global Snapshot Mapping
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Global Snapshot Mapping</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        @include('flash::message')

        <div class="clearfix"></div>
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Global Snapshot Mapping</h5>
                <span class="float-right">
                    <a class="btn btn-primary pull-right"
                        href="{{ route('global_ss_mapping.create') }}">Add New</a>
                </span>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table" id="kanbanAccounts-table">
                        <thead>
                            <tr>
                                <th>Level</th>
                                <th>Label</th>
                                <th>Fields</th>
                                <th colspan="3">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($GlobalSSMappings as $gsm)
                            <tr>
                                <td>{{ ($gsm->level) ? $gsm->level->label : "" }}</td>
                                <td>{{ $gsm->label }}</td>
                                <td>
                                    @foreach($gsm->global_ss_relations as $gsr)
                                    <div><b>{{$gsr->board->name}}</b></div>
                                    <div>swimlanes : {{$gsr->swimlane_names}}</div>
                                    <div>stages : {{$gsr->stage_names}}</div>
                                    @endforeach
                                </td>
                                <td>
                                    <a href="{{ route('global_ss_mapping.edit', [$gsm->id]) }}" class='btn btn-warning pr-2'><i
                                class="fa fa-edit"></i></a>
                                    {!! Form::open(['route' => ['global_ss_mapping.destroy', $gsm->id], 'method' => 'delete']) !!}
                                    <div class='btn-group'>
                                        {!! Form::button('<i class="fa fa-trash-o"></i>', ['type' => 'submit', 'class' => 'btn btn-danger', 'onclick' => "return confirm('Are you sure?')"]) !!}
                                    </div>
                                    {!! Form::close() !!}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
