<?php

use Illuminate\Support\Facades\Route;

include('web_builder.php');

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
  return redirect('login');
});



Auth::routes();

Route::group(['middleware' => 'auth'], function () {

  Route::get('import-command', function () {
    \Artisan::queue('import:kanban');

    \Flash::success('Import process initiated... Data will be imported soon...');

    return redirect(route('home'));
    
})->name('import-command');

  //crud builder routes
  Route::get('builder', '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@builder')->name('io_generator_builder');

  Route::get('field_template', '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@fieldTemplate')->name('io_field_template');

  Route::get('relation_field_template', '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@relationFieldTemplate')->name('io_relation_field_template');

  Route::post('generator_builder/generate', '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@generate')->name('io_generator_builder_generate');

  Route::post('generator_builder/rollback', '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@rollback')->name('io_generator_builder_rollback');

  Route::post(
      'generator_builder/generate-from-file',
      '\InfyOm\GeneratorBuilder\Controllers\GeneratorBuilderController@generateFromFile'
  )->name('io_generator_builder_generate_from_file');

  Route::get('home', 'HomeController@index')->name('home');

  Route::post('get_global_data', 'HomeController@get_global_data')->name("get_global_data");

  Route::post('get_workload_data', 'HomeController@get_workload_data')->name("get_workload_data");

  Route::post('get_exception_data_d', 'HomeController@get_exception_data_d')->name("get_exception_data_d");

  Route::resource('kanbanAccounts', 'KanbanAccountsController');

  Route::resource('swimlane_mapping', 'SwimlaneMappingController');

  Route::resource('swimlane_report', 'SwimlaneReportController');

  Route::resource('global_ss_mapping', 'GlobalSSMappingController');

  Route::resource('global_snapshot', 'GlobalSnapshotController');

  Route::resource('workload_mapping', 'WorkloadMappingController');

  Route::resource('workload', 'WorkloadController');

  Route::resource('invoice_mapping', 'InvoiceMappingController');

  Route::post('get_invoice_data', 'InvoiceController@get_invoice_data')->name("get_invoice_data");

  Route::resource('invoice', 'InvoiceController');

  Route::resource('exception_mapping', 'ExceptionMappingController');

  Route::post('get_exception_data', 'ExceptionController@get_exception_data')->name("get_exception_data");

  Route::resource('exception', 'ExceptionController');

  Route::get('board_order', 'BoardOrderController@index')->name('board_order');

  Route::post('board_order/update_order', 'BoardOrderController@update_order')->name('board_update_order');
});

// Route::get(
//     '/', function () {
//         return view('index');
//     }
// )->name('dashboard');

// Route::get('users', 'Admire2Controller@index');

// Route::post('users', 'Admire2Controller@store');



// // catch all routes
 Route::get('{name?}', 'Admire2Controller@showView');

