<?php $__env->startSection('title'); ?>
Exception <?php echo \Illuminate\View\Factory::parentPlaceholder('title'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header_styles'); ?>
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/chosen/css/chosen.css')); ?>"/>
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/daterangepicker/css/daterangepicker.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datepicker/css/bootstrap-datepicker.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/select2/css/select2.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/scroller.bootstrap.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/colReorder.bootstrap.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/dataTables.bootstrap4.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/datatables/css/responsive.bootstrap4.min.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/pages/dataTables.bootstrap.css')); ?>" />
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('vendors/multiselect/css/multi-select.css')); ?>"/>
    <!--End of plugin styles-->
    <!--Page level styles-->
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('css/pages/form_elements.css')); ?>"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<header class="head">
    <div class="main-bar">
        <div class="row">
            <div class="col-lg-6 col-sm-4">
                <h4 class="nav_top_align">
                    <i class="fa fa-th"></i>
                    Exception
                </h4>
            </div>
            <div class="col-lg-6 col-sm-8">
                <ol class="breadcrumb float-right nav_breadcrumb_top_align">
                    <li class="breadcrumb-item">
                        <a href="index">
                            <i class="fa fa-home" data-pack="default" data-tags=""></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="breadcrumb-item active">Exception</li>
                </ol>
            </div>
        </div>
    </div>
</header>

<!-- Main content -->
<div class="outer">
    <div class="inner bg-container">
        <div class="clearfix"></div>

        <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="clearfix"></div>
        <div class="card">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Filter</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg input_field_sections">
                        <form id="report_search_form">
                            <div class="form-group row form_inline_inputs_bot">
                                <div class="col-lg-3">
                                    <div class="input-group input-group-prepend">
                                        <span class="input-group-text border-right-0 rounded-left rounded_right">
                                                <i class="fa fa-calendar"></i>
                                        </span>
                                        <input type="text" autocomplete="off" class="form-control" value="<?php echo e(old('date', $request->date)); ?>" id="select_date"
                                               name="date">
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <select class="form-control chzn-select" name="board" id="board" tabindex="2">
                                        <?php $__currentLoopData = $boards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if($request->board == $b->id): ?> selected <?php endif; ?> value="<?php echo e($b->id); ?>"><?php echo e($b->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-3">
                                    <select class="form-control chzn-select" name="level_select" id="level_select">
                                        <option value="">Select Level</option>
                                        <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php if($request->level_select == $l->id): ?> selected <?php endif; ?> value="<?php echo e($l->id); ?>"><?php echo e($l->label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-1">
                                    <button class="btn btn-primary layout_btn_prevent btn-responsive form_inline_btn_margin-top">Search</button>
                                </div>
                                <div class="col-lg-1">
                                    <a class="btn btn-secondary" href="<?php echo e(route('exception.index')); ?>">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card m-t-20">
            <div class="card-header bg-white">
                <h5 class="card-title d-inline">Exception</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive m-t-20">
                    <table class="table table-stripped table-bordered" id="report_table">
                        <thead>
                            <tr>
                                <th>Job No.</th>
                                <th>Estimated Time</th>
                                <th>Logged Time</th>
                                <th>Exceed Estimate 10%</th>
                                <th>Assigned User</th>
                            </tr>
                        </thead>
                        <tbody>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery.uniform/js/jquery.uniform.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputlimiter/js/jquery.inputlimiter.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/chosen/js/chosen.jquery.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jquery-tagsinput/js/jquery.tagsinput.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pluginjs/jquery.validVal.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/inputmask/js/jquery.inputmask.bundle.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/moment/js/moment.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/daterangepicker/js/daterangepicker.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/datepicker/js/bootstrap-datepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-timepicker/js/bootstrap-timepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/bootstrap-switch/js/bootstrap-switch.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/autosize/js/jquery.autosize.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jasny-bootstrap/js/jasny-bootstrap.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/jasny-bootstrap/js/inputmask.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/datetimepicker/js/DateTimePicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/j_timepicker/js/jquery.timepicker.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/clockpicker/js/jquery-clockpicker.min.js')); ?>"></script>
    <!--end of plugin scripts-->
    <script type="text/javascript" src="<?php echo e(asset('js/form.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/pages/datetime_piker.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('vendors/select2/js/select2.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/jquery.dataTables.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/pluginjs/dataTables.tableTools.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.colReorder.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.buttons.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/responsive.bootstrap4.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.rowReorder.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.colVis.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.html5.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.bootstrap.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/buttons.print.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/datatables/js/dataTables.scroller.min.js')); ?>"></script>
<!-- end of plugin scripts -->
<!--Page level scripts-->
<script type="text/javascript" src="<?php echo e(asset('js/pages/simple_datatables.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendors/multiselect/js/jquery.multi-select.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/pages/form_elements.js')); ?>"></script>

<script type="text/javascript">
    $(document).ready(function() {

        var table = $('#report_table').DataTable({
            processing: true,
            serverSide: true,
            order: [[3, 'desc']],
            ajax: {
                    url: '<?php echo e(route("get_exception_data")); ?>',
                    type: "POST",
                    data: function (d) {
                        d._token = "<?php echo e(csrf_token()); ?>"
                        d.board = $('#board').val();
                        d.level_select = $("#level_select").val();
                    }
                },
            columns: [
                { data: 'name', name: 'name' },
                { data: 'estimated_time', name: 'estimated_time' },
                { data: 'logged_time', name: 'logged_time' },
                { data: 'exceed_estimate', name: 'exceed_estimate' },
                { data: 'assigned_user', name: 'assigned_user' },
            ],
            'columnDefs': [
               {
                    "targets": 1,
                    "className": "text-center",
               },
               {
                    "targets": 2,
                    "className": "text-center",
               }
             ]
            }); 

        load_datatable();

        $("#board").on("change", function(){
            load_datatable();
        })

        $("#level_select").on("change", function(){
            load_datatable();
        })


        function load_datatable()
        {
           table.ajax.reload();
        }

        $('#select_date').datepicker({
            format: 'dd-mm-yyyy',
            todayHighlight: true,
            autoclose: true,
            orientation:"bottom"
        });
        
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.compact_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ncengau/public_html/resources/views/exception/index.blade.php ENDPATH**/ ?>